(function() {
  //    FILE:EventModel
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 2/18/13
  //    Farmerswife SL.
  define(['Backbone', 'moment', 'models/request/RequestModel'], function(Backbone, Moment, RequestModel) {
    var ProjectModel;
    return ProjectModel = class ProjectModel extends Backbone.Model {
      initialize() {
        //console.log "Model ContactModel initialized"
        return this.reqMdl = new RequestModel();
      }

      get_project_detail(usr, projectID) {
        var jsonReq, response, that, xmlReq;
        jsonReq = this.reqMdl.get('JGetProjectDetails');
        this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
        this.reqMdl.__setNodeValue(jsonReq, 'projectID', projectID);
        xmlReq = this.reqMdl.__getXML(jsonReq);
        that = this;
        response = this.reqMdl.__send_server_xmlrequest(xmlReq);
        response.done(function(data, textStatus, jqXHR) {
          var jsonObj;
          jsonObj = data;
          //console.log data
          if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
            window.localStorage.clear();
            window.location.href = 'index.html?expired=1';
          }
          if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
            that.set(jsonObj.Result);
            return that.trigger('project_updated');
          }
        }).fail(function(data, textStatus, jqXHR) {
          //console.log "ERROR #{textStatus} "+data
          return false;
        }).always(function(data, textStatus) {
          return $.mobile.loading('hide');
        });
        return this;
      }

      get_project_booking(usr, projectID) {
        var jsonReq, response, that, xmlReq;
        jsonReq = this.reqMdl.get('JGetBookingProject');
        this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
        this.reqMdl.__setNodeValue(jsonReq, 'projectID', projectID);
        xmlReq = this.reqMdl.__getXML(jsonReq);
        that = this;
        response = this.reqMdl.__send_server_xmlrequest(xmlReq);
        response.done(function(data, textStatus, jqXHR) {
          var jsonObj;
          jsonObj = data;
          //console.log data
          if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
            window.localStorage.clear();
            window.location.href = 'index.html?expired=1';
          }
          if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
            that.set({
              bookingProject: jsonObj.Result
            }, {
              silent: true
            });
            return that.trigger('project_booking_updated');
          }
        }).fail(function(data, textStatus, jqXHR) {
          //console.log "ERROR #{textStatus} "+data
          return false;
        }).always(function(data, textStatus) {
          return $.mobile.loading('hide');
        });
        return this;
      }

      get_project_events(usr, projectID) {
        var jsonReq, response, that, xmlReq;
        that = this;
        jsonReq = this.reqMdl.get('JGetEvents');
        this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
        this.reqMdl.__setNodeValue(jsonReq, 'objectType', 'project');
        this.reqMdl.__setNodeValue(jsonReq, 'objectID', projectID);
        xmlReq = this.reqMdl.__getXML(jsonReq);
        response = this.reqMdl.__send_server_xmlrequest(xmlReq);
        response.done(function(data, textStatus, jqXHR) {
          var events, jsonObj;
          jsonObj = data;
          events = jsonObj.Result.Event;
          if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
            that.set({
              events: events
            });
            return that.trigger('project_events_updated');
          } else {
            if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
              window.localStorage.clear();
              return window.location.href = 'index.html';
            }
          }
        }).fail(function(data, textStatus, jqXHR) {
          //console.log "ERROR #{textStatus} "+data
          return false;
        }).always(function(data, textStatus) {
          return $.mobile.loading('hide');
        });
        return this;
      }

      save_project(sessionID, project) {
        var jsonReq, parent, response, that, xmlReq;
        that = this;
        parent = 'Project';
        jsonReq = this.reqMdl.get('JCommitProject');
        this.reqMdl.__setNodeValue(jsonReq, 'sessionID', sessionID);
        if (project.name) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'name', project.name);
        }
        if (project.id) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'id', project.id);
        }
        if (project.contactID) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'contactID', project.contactID);
        }
        if (project.contactName) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'contactName', project.contactName);
        }
        if (project.contactCompanyName) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'contactCompanyName', project.contactCompanyName);
        }
        if (project.note) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'note', project.note);
        }
        if (project.CustomField) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'CustomField', project.CustomField);
        }
        xmlReq = this.reqMdl.__getXML(jsonReq);
        response = this.reqMdl.__send_server_xmlrequest(xmlReq);
        response.done(function(data, textStatus, jqXHR) {
          var jsonObj;
          jsonObj = data;
          if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
            return that.trigger('project_saved');
          } else {
            if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
              window.localStorage.clear();
              return window.location.href = 'index.html';
            }
          }
        }).fail(function(data, textStatus, jqXHR) {
          //console.log "ERROR #{textStatus} "+data
          return false;
        }).always(function(data, textStatus) {
          return $.mobile.loading('hide');
        });
        return this;
      }

    };
  });

}).call(this);
